/* ============ */
/* AddFrac.c	*/
/* ============ */
#include <defcodes.h>

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define	F( P )	P
# else
#	define	F( P )	()
# endif

/* INDENT OFF */
extern	long	double GetGCD F((long double, long double));

# undef F
/* INDENT ON */

#define	REDUCE_FRACTION(N3, D3)		\
    {					\
	LDBL	Gcd;			\
	Gcd = GetGCD(N3, D3);		\
	if (Gcd == 1)			\
	{				\
	    /* Do Nothing. */		\
	}				\
	else				\
	{				\
	    N3 /= Gcd;			\
	    D3 /= Gcd;			\
	}				\
    }

/* ==================================================================== */
/* AddFrac - Adds two fraction given as Numer & Denom, stores new ones	*/
/* ==================================================================== */
void
AddFrac(long double N1, long double D1, long double N2, long double D2,
	long double *N3, long double *D3)
{
    *N3 = N2 * D1 + N1 * D2;
    *D3 = D1 * D2;

    REDUCE_FRACTION(*N3, *D3);
}
